--[[---------------------------------------------------------------------------
	Chocolatier Two Port Data: Shanghai
	Copyright (c) 2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Characters

DefineCharacter { name = "sh_factorykeep"}
DefineCharacter { name = "sh_marketkeep" }
DefineCharacter { name = "sh_shopkeep" }
DefineCharacter { name = "sh_bundkeep" }
DefineCharacter { name = "sh_sassoonkeep" }
DefineCharacter { name = "sh_hotelkeep" }

-------------------------------------------------------------------------------
-- Port Definition

DefinePort
{
	name = "shanghai",
	available = false,
	ambient="sfx/metropolitan_loop.ogg",
	
	layout =
	{
		-- Clouds
		SpriteLayer { image="clouds_02", time=380000, loop=true, htile=true, path={{-400,100},{100,100},{700,100},{1200,100}},},
		SpriteLayer { image="clouds_02", time=220000, loop=true, htile=true, path={{0,70},{100,70},{700,70},{800,70}},},
		
		
		-- Planes
		SpriteLayer { imagelist=portPlanes, scale=.25, time=13000,hold=5000,bounce=true,
			path={{-89,59},{41,130},{312,66},{599,55},{701,52},{816,84},{886,108},}, },
	
		Factory { name="sh_factory", character="sh_factorykeep", price = 2620000, x=39+134/2,y=130+129/2 },
		PlayerLogo { name="logo", x=50+100/2,y=125+57/2, scale=0.24, target="sh_factory" },

		EmptyBuilding { name="sh_bund", character={"sh_bundkeep"}, x=538+262/2,y=176+90/2 },

		EmptyBuilding { name="sh_hotel", character={"sh_hotelkeep"}, ambient="sfx/other_loop.ogg", x=385+57/2,y=41+168/2 },		-- 1934
		SpriteLayer { image="sh_hotelmask", x=366+105/2,y=166+71/2 },

		EmptyBuilding { name="sh_sassoon", character={"sh_sassoonkeep"}, ambient="sfx/other_loop.ogg", x=511+69/2, y=54+218/2 },	-- 1929
		
		-- Perspective cars down market street
		SpriteLayer { image="car_07", nearscale=.3,farscale=.05,far=212,near=300,
			path={{465,285},{443,263},{414,236},{390,212}} },
		SpriteLayer { image="car_12", nearscale=.3,farscale=.05,far=212,near=300,
			path={{389,214},{412,238},{437,269},{454,293},}, },

		Market { name="sh_market", character="sh_marketkeep", x=353+183/2,y=192+98/2,
			inventory = { sugar=true, vanilla=true, cinnamon = true, ginger=true, pecan=true, milk=true, macadamia = true, caramel = true } },

		SpriteLayer { image="sh_streetmask", x=358+58/2,y=201+104/2 },

		Shop { name="sh_shop", character="sh_shopkeep", x=242+124/2,y=57+261/2, labelx=300,labely=230 },
		SpriteLayer { image="sh_shopmask", x=0+307/2,y=111+236/2 },
		
		-- Horizontal Cars down harbor street
		SpriteLayer { image="car_10", scale=.2,
			path={{387,340},{540,272},{548,266},{880,240}} },

		-- Perspective Cars on harbor street
		SpriteLayer { image="car_10", scale=.25,time=8000,hold=3000,
			path={{104,463},{164,395},{203,365},{407,307},}, },
		SpriteLayer { image="car_07", scale=.3,
			path={{330,650},{340,464},{329,387},{395,352},}, },
		
		SpriteLayer { image="sh_harbor", x=358+442/2,y=239+161/2 },
		
		-- Boats
		SpriteLayer { image="boat_03", scale=.2, time=35000,hold=8000,bounce=true,
			path={{894,251},{810,266},{719,274},{671,289},{614,298},{619,334},{675,312},{703,308},{760,306},{883,295},}, },
		SpriteLayer { image="boat_03", scale=.3, time=20000,hold=5000,bounce=true,
			path={{565,362},{685,356},{771,337},{882,315},}, },
		SpriteLayer { image="boat_03", scale=.3, time=22000,hold=6000,bounce=true,
			path={{562,377},{691,371},{780,369},{875,361},}, },
	}
}
